/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.TableNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.UniqueConstraintNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.AbstractRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.EntityMappingConfigurationWithTable;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneCycleConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneOwnedBySourceConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneOwnedByTargetConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;

public class OneToOneRelationConfigurer<C, I, TRGT, TRGTID>
extends AbstractRelationConfigurer<C, I, TRGT, TRGTID> {
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final UniqueConstraintNamingStrategy uniqueConstraintNamingStrategy;

    public OneToOneRelationConfigurer(Dialect dialect, ConnectionConfiguration connectionConfiguration, ConfiguredRelationalPersister<C, I> sourcePersister, TableNamingStrategy tableNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy, UniqueConstraintNamingStrategy uniqueConstraintNamingStrategy, PersisterBuilderContext currentBuilderContext) {
        super(dialect, connectionConfiguration, sourcePersister, tableNamingStrategy, currentBuilderContext);
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.uniqueConstraintNamingStrategy = uniqueConstraintNamingStrategy;
    }

    public void configure(OneToOneRelation<C, TRGT, TRGTID> oneToOneRelation) {
        OneToOneConfigurerTemplate configurer = oneToOneRelation.isRelationOwnedByTarget() ? new OneToOneOwnedByTargetConfigurer(this.sourcePersister, oneToOneRelation, this.joinColumnNamingStrategy, this.foreignKeyNamingStrategy, this.uniqueConstraintNamingStrategy, this.dialect, this.connectionConfiguration) : new OneToOneOwnedBySourceConfigurer(this.sourcePersister, oneToOneRelation, this.joinColumnNamingStrategy, this.foreignKeyNamingStrategy, this.uniqueConstraintNamingStrategy);
        String relationName = AccessorDefinition.giveDefinition(oneToOneRelation.getTargetProvider()).getName();
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = oneToOneRelation.getTargetMappingConfiguration();
        if (this.currentBuilderContext.isCycling(targetMappingConfiguration)) {
            Class targetEntityType = targetMappingConfiguration.getEntityType();
            OneToOneCycleConfigurer cycleSolver = (OneToOneCycleConfigurer)Iterables.find(this.currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof OneToOneCycleConfigurer && ((OneToOneCycleConfigurer)p).getEntityType() == targetEntityType);
            if (cycleSolver == null) {
                cycleSolver = new OneToOneCycleConfigurer(targetEntityType);
                this.currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
            }
            cycleSolver.addCycleSolver(relationName, configurer);
        } else {
            Table targetTable = this.determineTargetTable(oneToOneRelation);
            ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = this.persisterBuilder.build(new EntityMappingConfigurationWithTable<TRGT, TRGTID>(targetMappingConfiguration, targetTable));
            String tableAlias = relationName.replace('.', '_');
            configurer.configure(tableAlias, targetPersister, oneToOneRelation.isFetchSeparately());
        }
    }

    private Table determineTargetTable(OneToOneRelation<C, TRGT, TRGTID> oneToOneRelation) {
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = oneToOneRelation.getTargetMappingConfiguration();
        Table targetTable = (Table)Nullable.nullable((Object)targetMappingConfiguration.getTable()).getOr(Nullable.nullable(oneToOneRelation.getReverseColumn()).map(Column::getTable).get());
        if (targetTable == null) {
            targetTable = this.lookupTableInRegisteredPersisters(targetMappingConfiguration.getEntityType());
        }
        return targetTable;
    }
}

